# Plant Identifier 🌿

A web application built using **React** and **Next.js** that allows users to upload or capture plant images and retrieve detailed information about the plant species using a plant identification API.

## Features

- **Upload or Capture Plant Images**: Easily submit plant photos for identification.
- **Accurate Plant Information**: Utilizes a powerful plant identification API to provide details about the plant species.
- **Responsive Design**: Built with **Tailwind CSS** to ensure a clean and user-friendly interface across all devices.
- **Fast and Scalable**: Powered by **Next.js** for optimized performance.

## Tech Stack

- **React**: Front-end framework for building a dynamic and interactive user interface.
- **Next.js**: Provides server-side rendering and enhanced performance.
- **Tailwind CSS**: Utility-first CSS framework for styling.
- **Plant Identification API**: External API to fetch plant data based on the uploaded image.

## Installation and Setup

To get started with the project, follow these steps:

1. Clone the repository:
    ```bash
    git clone https://github.com/sayan365/Plant-Identifier.git
    ```

2. Navigate to the project directory:
    ```bash
    cd Plant-Identifier
    ```

3. Install dependencies:
    ```bash
    npm install
    ```

4. Create a `.env.local` file and add your plant identification API key:
    ```bash
    NEXT_PUBLIC_API_KEY=your_api_key_here
    ```

5. Start the development server:
    ```bash
    npm run dev
    ```

6. Open your browser and navigate to:
    ```
    http://localhost:3000
    ```

## How It Works

1. The user uploads or captures an image of a plant.
2. The app sends the image to the plant identification API.
3. The API returns detailed information about the plant, such as its species, common name, and more.
4. The app displays the information to the user in a clean and intuitive interface.

## Contributions

Contributions, issues, and feature requests are welcome! Feel free to open an issue or submit a pull request.

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.

---

**Author**: Sayan  
For any inquiries, feel free to contact me via GitHub or other platforms.
